/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.match;

import org.apache.skywalking.apm.agent.core.plugin.match.IndirectMatch;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.type.TypeDescription;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatcher;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatchers;

public class PrefixMatch
implements IndirectMatch {
    private String[] prefixes;

    private PrefixMatch(String ... prefixes) {
        if (prefixes == null || prefixes.length == 0) {
            throw new IllegalArgumentException("prefixes argument is null or empty");
        }
        this.prefixes = prefixes;
    }

    @Override
    public ElementMatcher.Junction buildJunction() {
        ElementMatcher.Junction junction = null;
        for (String prefix : this.prefixes) {
            junction = junction == null ? ElementMatchers.nameStartsWith(prefix) : junction.or(ElementMatchers.nameStartsWith(prefix));
        }
        return junction;
    }

    @Override
    public boolean isMatch(TypeDescription typeDescription) {
        for (String prefix : this.prefixes) {
            if (!typeDescription.getName().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static PrefixMatch nameStartsWith(String ... prefixes) {
        return new PrefixMatch(prefixes);
    }
}

