/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.netty.http.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.plugin.netty.http.common.AttributeKeys;
import org.apache.skywalking.apm.plugin.netty.http.utils.TypeUtils;

@ChannelHandler.Sharable
public class NettyHttpResponseEncoderTracingHandler
extends ChannelOutboundHandlerAdapter {
    private static final ILog LOGGER = LogManager.getLogger(NettyHttpResponseEncoderTracingHandler.class);

    public static NettyHttpResponseEncoderTracingHandler getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private NettyHttpResponseEncoderTracingHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        try {
            if (!TypeUtils.isHttpResponse(msg)) {
                return;
            }
            HttpResponse response = (HttpResponse)msg;
            int code = response.status().code();
            if (HttpResponseStatus.CONTINUE.code() == code) {
                return;
            }
            Channel channel = ctx.channel();
            AbstractSpan span = (AbstractSpan)channel.attr(AttributeKeys.HTTP_SERVER_SPAN).getAndSet(null);
            if (span == null) {
                return;
            }
            Tags.HTTP_RESPONSE_STATUS_CODE.set(span, Integer.valueOf(code));
            if (code >= 400) {
                span.errorOccurred();
            }
            span.asyncFinish();
        }
        catch (Exception e) {
            LOGGER.error("Fail to trace netty http response", (Throwable)e);
        }
        finally {
            ctx.write(msg, promise);
        }
    }

    private static class SingletonHolder {
        private static final NettyHttpResponseEncoderTracingHandler INSTANCE = new NettyHttpResponseEncoderTracingHandler();

        private SingletonHolder() {
        }
    }
}

