/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.thrift;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.thrift.ProcessFunction;
import org.apache.thrift.TBaseAsyncProcessor;
import org.apache.thrift.TBaseProcessor;
import org.apache.thrift.TProcessor;

public class TMultiplexedProcessorRegisterInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final ILog LOGGER = LogManager.getLogger(TMultiplexedProcessorRegisterInterceptor.class);

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        Map processMap = (Map)objInst.getSkyWalkingDynamicField();
        String serviceName = (String)allArguments[0];
        TProcessor processor = (TProcessor)allArguments[1];
        processMap.putAll(this.getProcessMap(serviceName, processor));
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }

    private Map<String, ProcessFunction> getProcessMap(String serviceName, TProcessor processor) {
        HashMap<String, ProcessFunction> hashMap = new HashMap<String, ProcessFunction>();
        if (processor instanceof TBaseProcessor) {
            Map processMapView = ((TBaseProcessor)processor).getProcessMapView();
            processMapView.forEach((k, v) -> hashMap.put(serviceName + ":" + k, (ProcessFunction)v));
        } else if (processor instanceof TBaseAsyncProcessor) {
            Map processMapView = ((TBaseAsyncProcessor)processor).getProcessMapView();
            processMapView.forEach((k, v) -> hashMap.put(serviceName + ":" + k, (ProcessFunction)v));
        } else {
            LOGGER.warn("Not support this processor:{}", new Object[]{processor.getClass().getName()});
        }
        return hashMap;
    }
}

