/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context.trace;

import org.apache.skywalking.apm.agent.core.conf.Constants;
import org.apache.skywalking.apm.agent.core.context.TracingContext;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractTracingSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.context.trace.StackBasedTracingSpan;
import org.apache.skywalking.apm.network.trace.component.Component;

public class EntrySpan
extends StackBasedTracingSpan {
    private int currentMaxDepth = 0;

    public EntrySpan(int spanId, int parentSpanId, String operationName, TracingContext owner) {
        super(spanId, parentSpanId, operationName, owner);
    }

    @Override
    public EntrySpan start() {
        this.currentMaxDepth = ++this.stackDepth;
        if (this.stackDepth == 1) {
            super.start();
        }
        this.clearWhenRestart();
        return this;
    }

    @Override
    public EntrySpan tag(String key, String value) {
        if (this.stackDepth == this.currentMaxDepth || this.isInAsyncMode) {
            super.tag(key, value);
        }
        return this;
    }

    @Override
    public AbstractTracingSpan setLayer(SpanLayer layer) {
        if (this.stackDepth == this.currentMaxDepth || this.isInAsyncMode) {
            return super.setLayer(layer);
        }
        return this;
    }

    @Override
    public AbstractTracingSpan setComponent(Component component) {
        if (this.stackDepth == this.currentMaxDepth || this.isInAsyncMode) {
            return super.setComponent(component);
        }
        return this;
    }

    @Override
    public AbstractTracingSpan setOperationName(String operationName) {
        if (this.stackDepth == this.currentMaxDepth || this.isInAsyncMode) {
            return super.setOperationName(operationName);
        }
        return this;
    }

    @Override
    public EntrySpan log(Throwable t) {
        super.log(t);
        return this;
    }

    @Override
    public boolean isEntry() {
        return true;
    }

    @Override
    public boolean isExit() {
        return false;
    }

    private void clearWhenRestart() {
        this.componentId = Constants.NULL_VALUE;
        this.layer = null;
        this.logs = null;
        this.tags = null;
    }
}

