/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.agent.core.base64.Base64;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.StringTag;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.util.StringUtil;

public class CorrelationContext {
    private final Map<String, String> data = new ConcurrentHashMap<String, String>(Config.Correlation.ELEMENT_MAX_NUMBER);
    private static final List<String> AUTO_TAG_KEYS = StringUtil.isNotEmpty(Config.Correlation.AUTO_TAG_KEYS) ? Arrays.asList(Config.Correlation.AUTO_TAG_KEYS.split(",")) : new ArrayList<String>();

    public Optional<String> put(String key, String value) {
        if (key == null) {
            return Optional.empty();
        }
        if (StringUtil.isEmpty(value)) {
            return Optional.ofNullable(this.data.remove(key));
        }
        if (value.length() > Config.Correlation.VALUE_MAX_LENGTH) {
            return Optional.empty();
        }
        if (this.data.containsKey(key)) {
            String previousValue = this.data.put(key, value);
            return Optional.of(previousValue);
        }
        if (this.data.size() >= Config.Correlation.ELEMENT_MAX_NUMBER) {
            return Optional.empty();
        }
        if (AUTO_TAG_KEYS.contains(key) && ContextManager.isActive()) {
            ContextManager.activeSpan().tag(new StringTag(key), value);
        }
        this.data.put(key, value);
        return Optional.empty();
    }

    public Optional<String> get(String key) {
        if (key == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.data.get(key));
    }

    String serialize() {
        if (this.data.isEmpty()) {
            return "";
        }
        return this.data.entrySet().stream().map(entry -> Base64.encode((String)entry.getKey()) + ":" + Base64.encode((String)entry.getValue())).collect(Collectors.joining(","));
    }

    void deserialize(String value) {
        if (StringUtil.isEmpty(value)) {
            return;
        }
        for (String perData : value.split(",")) {
            if (this.data.size() >= Config.Correlation.ELEMENT_MAX_NUMBER) break;
            String[] parts = perData.split(":");
            if (parts.length != 2) continue;
            this.data.put(Base64.decode2UTFString(parts[0]), Base64.decode2UTFString(parts[1]));
        }
    }

    void inject(ContextCarrier carrier) {
        carrier.getCorrelationContext().data.putAll(this.data);
    }

    void extract(ContextCarrier carrier) {
        Map<String, String> carrierCorrelationContext = carrier.getCorrelationContext().data;
        for (Map.Entry<String, String> entry : carrierCorrelationContext.entrySet()) {
            if (this.data.size() >= Config.Correlation.ELEMENT_MAX_NUMBER) break;
            this.data.put(entry.getKey(), entry.getValue());
        }
    }

    void handle(AbstractSpan span) {
        AUTO_TAG_KEYS.forEach(key -> this.get((String)key).ifPresent(val -> span.tag(new StringTag((String)key), (String)val)));
    }

    public CorrelationContext clone() {
        CorrelationContext context = new CorrelationContext();
        context.data.putAll(this.data);
        return context;
    }

    void continued(ContextSnapshot snapshot) {
        this.data.putAll(snapshot.getCorrelationContext().data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CorrelationContext that = (CorrelationContext)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }
}

