/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.concurrent;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.plugin.spring.commons.EnhanceCacheObjects;

public class FailureCallbackInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        EnhanceCacheObjects cacheValues = (EnhanceCacheObjects)objInst.getSkyWalkingDynamicField();
        if (cacheValues == null) {
            return;
        }
        AbstractSpan span = ContextManager.createLocalSpan((String)("future/failureCallback:" + cacheValues.getOperationName()));
        span.log((Throwable)allArguments[0]).setComponent((Component)cacheValues.getComponent()).setLayer(cacheValues.getSpanLayer());
        ContextManager.continued((ContextSnapshot)cacheValues.getContextSnapshot());
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        EnhanceCacheObjects cacheValues = (EnhanceCacheObjects)objInst.getSkyWalkingDynamicField();
        if (cacheValues == null) {
            return ret;
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        EnhanceCacheObjects cacheValues = (EnhanceCacheObjects)objInst.getSkyWalkingDynamicField();
        if (cacheValues == null) {
            return;
        }
        ContextManager.activeSpan().log(t);
    }
}

