/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.guava.eventbus;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.guava.eventbus.EventWrapper;
import org.apache.skywalking.apm.plugin.guava.eventbus.SubscriberInfo;

public class EventBusSubscriberInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        SubscriberInfo subscriberInfo = (SubscriberInfo)objInst.getSkyWalkingDynamicField();
        AbstractSpan span = ContextManager.createLocalSpan((String)("Guava/EventBus/" + subscriberInfo.getClassName() + "/" + subscriberInfo.getMethodName()));
        span.setComponent((Component)ComponentsDefine.GUAVA_EVENT_BUS);
        Object event = allArguments[0];
        if (event instanceof EventWrapper) {
            EventWrapper eventWrapper = (EventWrapper)event;
            allArguments[0] = eventWrapper.getEvent();
            ContextManager.continued((ContextSnapshot)eventWrapper.getContextSnapshot());
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

