/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.grpc.v1.server;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.grpc.v1.OperationNameFormatUtil;
import org.apache.skywalking.apm.plugin.grpc.v1.server.TracingServerCall;
import org.apache.skywalking.apm.plugin.grpc.v1.server.TracingServerCallListener;
import org.apache.skywalking.apm.util.StringUtil;

public class ServerInterceptor
implements io.grpc.ServerInterceptor {
    static final Context.Key<ContextSnapshot> CONTEXT_SNAPSHOT_KEY = Context.key((String)"skywalking-grpc-context-snapshot");
    static final Context.Key<AbstractSpan> ACTIVE_SPAN_KEY = Context.key((String)"skywalking-grpc-active-span");

    public <REQUEST, RESPONSE> ServerCall.Listener<REQUEST> interceptCall(ServerCall<REQUEST, RESPONSE> call, Metadata headers, ServerCallHandler<REQUEST, RESPONSE> handler) {
        ContextCarrier contextCarrier = new ContextCarrier();
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            String contextValue = (String)headers.get(Metadata.Key.of((String)(next = next.next()).getHeadKey(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
            if (StringUtil.isEmpty((String)contextValue)) continue;
            next.setHeadValue(contextValue);
        }
        AbstractSpan span = ContextManager.createEntrySpan((String)OperationNameFormatUtil.formatOperationName(call.getMethodDescriptor()), (ContextCarrier)contextCarrier);
        span.setComponent((Component)ComponentsDefine.GRPC);
        span.setLayer(SpanLayer.RPC_FRAMEWORK);
        ContextSnapshot contextSnapshot = ContextManager.capture();
        AbstractSpan asyncSpan = span.prepareForAsync();
        Context context = Context.current().withValues(CONTEXT_SNAPSHOT_KEY, (Object)contextSnapshot, ACTIVE_SPAN_KEY, (Object)asyncSpan);
        ServerCall.Listener listener = Contexts.interceptCall((Context)context, new TracingServerCall<REQUEST, RESPONSE>(call), (Metadata)headers, (serverCall, metadata) -> new TracingServerCallListener(handler.startCall(serverCall, metadata), serverCall.getMethodDescriptor()));
        ContextManager.stopSpan((AbstractSpan)asyncSpan);
        return listener;
    }
}

