/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.skywalking.apm.agent.core.boot.BootService;
import org.apache.skywalking.apm.agent.core.boot.DefaultImplementor;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.conf.dynamic.ConfigurationDiscoveryService;
import org.apache.skywalking.apm.agent.core.conf.dynamic.watcher.IgnoreSuffixPatternsWatcher;
import org.apache.skywalking.apm.agent.core.conf.dynamic.watcher.SpanLimitWatcher;
import org.apache.skywalking.apm.agent.core.context.AbstractTracerContext;
import org.apache.skywalking.apm.agent.core.context.IgnoredTracerContext;
import org.apache.skywalking.apm.agent.core.context.TracingContext;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelListener;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelManager;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelStatus;
import org.apache.skywalking.apm.agent.core.sampling.SamplingService;
import org.apache.skywalking.apm.util.StringUtil;

@DefaultImplementor
public class ContextManagerExtendService
implements BootService,
GRPCChannelListener {
    private volatile Set ignoreSuffixSet;
    private volatile GRPCChannelStatus status = GRPCChannelStatus.DISCONNECT;
    private IgnoreSuffixPatternsWatcher ignoreSuffixPatternsWatcher;
    private SpanLimitWatcher spanLimitWatcher;

    @Override
    public void prepare() {
        ServiceManager.INSTANCE.findService(GRPCChannelManager.class).addChannelListener(this);
    }

    @Override
    public void boot() {
        this.ignoreSuffixSet = Stream.of(Config.Agent.IGNORE_SUFFIX.split(",")).collect(Collectors.toSet());
        this.ignoreSuffixPatternsWatcher = new IgnoreSuffixPatternsWatcher("agent.ignore_suffix", this);
        this.spanLimitWatcher = new SpanLimitWatcher("agent.span_limit_per_segment");
        ConfigurationDiscoveryService configurationDiscoveryService = ServiceManager.INSTANCE.findService(ConfigurationDiscoveryService.class);
        configurationDiscoveryService.registerAgentConfigChangeWatcher(this.spanLimitWatcher);
        configurationDiscoveryService.registerAgentConfigChangeWatcher(this.ignoreSuffixPatternsWatcher);
        this.handleIgnoreSuffixPatternsChanged();
    }

    @Override
    public void onComplete() {
    }

    @Override
    public void shutdown() {
    }

    public AbstractTracerContext createTraceContext(String operationName, boolean forceSampling) {
        AbstractTracerContext context;
        if (!Config.Agent.KEEP_TRACING && GRPCChannelStatus.DISCONNECT.equals((Object)this.status)) {
            return new IgnoredTracerContext();
        }
        int suffixIdx = operationName.lastIndexOf(".");
        if (suffixIdx > -1 && this.ignoreSuffixSet.contains(operationName.substring(suffixIdx))) {
            context = new IgnoredTracerContext();
        } else {
            SamplingService samplingService = ServiceManager.INSTANCE.findService(SamplingService.class);
            context = forceSampling || samplingService.trySampling(operationName) ? new TracingContext(operationName, this.spanLimitWatcher) : new IgnoredTracerContext();
        }
        return context;
    }

    @Override
    public void statusChanged(GRPCChannelStatus status) {
        this.status = status;
    }

    public void handleIgnoreSuffixPatternsChanged() {
        if (StringUtil.isNotBlank(this.ignoreSuffixPatternsWatcher.getIgnoreSuffixPatterns())) {
            this.ignoreSuffixSet = Stream.of(this.ignoreSuffixPatternsWatcher.getIgnoreSuffixPatterns().split(",")).collect(Collectors.toSet());
        }
    }
}

