/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.jvm.memorypool;

import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.apm.agent.core.jvm.memorypool.MemoryPoolMetricsAccessor;
import org.apache.skywalking.apm.network.language.agent.v3.MemoryPool;
import org.apache.skywalking.apm.network.language.agent.v3.PoolType;

public class ZGCCollectorModule
implements MemoryPoolMetricsAccessor {
    private final List<MemoryPoolMXBean> beans;

    public ZGCCollectorModule(List<MemoryPoolMXBean> beans) {
        this.beans = beans;
    }

    @Override
    public List<MemoryPool> getMemoryPoolMetricsList() {
        LinkedList<MemoryPool> poolList = new LinkedList<MemoryPool>();
        for (MemoryPoolMXBean bean : this.beans) {
            PoolType type;
            String name = bean.getName();
            if (name.equals("ZHeap")) {
                type = PoolType.ZHEAP_USAGE;
            } else if (name.equals("Metaspace")) {
                type = PoolType.METASPACE_USAGE;
            } else if (name.equals("Compressed Class Space")) {
                type = PoolType.COMPRESSED_CLASS_SPACE_USAGE;
            } else if (name.equals("CodeHeap 'non-nmethods'")) {
                type = PoolType.CODEHEAP_NON_NMETHODS_USAGE;
            } else if (name.equals("CodeHeap 'profiled nmethods'")) {
                type = PoolType.CODEHEAP_PROFILED_NMETHODS_USAGE;
            } else {
                if (!name.equals("CodeHeap 'non-profiled nmethods'")) continue;
                type = PoolType.CODEHEAP_NON_PROFILED_NMETHODS_USAGE;
            }
            MemoryUsage usage = bean.getUsage();
            poolList.add(MemoryPool.newBuilder().setType(type).setInit(usage.getInit()).setMax(usage.getMax()).setCommitted(usage.getCommitted()).setUsed(usage.getUsed()).build());
        }
        return poolList;
    }
}

