/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.plugin.bootstrap.IBootstrapLog;

public class BootstrapInterRuntimeAssist {
    private static final String AGENT_CLASSLOADER_DEFAULT = "org.apache.skywalking.apm.agent.core.plugin.loader.AgentClassLoader";
    private static final String DEFAULT_AGENT_CLASSLOADER_INSTANCE = "DEFAULT_LOADER";
    private static final String LOG_MANAGER_CLASS = "org.apache.skywalking.apm.agent.core.plugin.bootstrap.BootstrapPluginLogBridge";
    private static final String LOG_MANAGER_GET_LOGGER_METHOD = "getLogger";
    private static final PrintStream OUT = System.out;

    public static ClassLoader getAgentClassLoader() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                return null;
            }
            Class<?> agentClassLoaderClass = Class.forName(AGENT_CLASSLOADER_DEFAULT, true, loader);
            Field defaultLoaderField = agentClassLoaderClass.getDeclaredField(DEFAULT_AGENT_CLASSLOADER_INSTANCE);
            defaultLoaderField.setAccessible(true);
            ClassLoader defaultAgentClassLoader = (ClassLoader)defaultLoaderField.get(null);
            return defaultAgentClassLoader;
        }
        catch (Exception e) {
            e.printStackTrace(OUT);
            return null;
        }
    }

    public static IBootstrapLog getLogger(ClassLoader defaultAgentClassLoader, String interceptor) {
        try {
            Class<?> logManagerClass = Class.forName(LOG_MANAGER_CLASS, true, defaultAgentClassLoader);
            Method getLogger = logManagerClass.getMethod(LOG_MANAGER_GET_LOGGER_METHOD, String.class);
            return (IBootstrapLog)getLogger.invoke(null, interceptor + "_internal");
        }
        catch (Exception e) {
            e.printStackTrace(OUT);
            return null;
        }
    }

    public static <T> T createInterceptor(ClassLoader defaultAgentClassLoader, String className, IBootstrapLog log) {
        try {
            Class<?> interceptor = Class.forName(className, true, defaultAgentClassLoader);
            return (T)interceptor.newInstance();
        }
        catch (Exception e) {
            log.error(e, "Interceptor[{}] not found", className);
            return null;
        }
    }
}

