/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.toolkit.activation.micrometer;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import java.util.Locale;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;

class TaggingHelper {
    private static final String DB_TAG_PREFIX = "jdbc";
    private static final String HTTP_TAG_PREFIX = "http";
    private static final String RPC_TAG_PREFIX = "rpc";
    private static final String MESSAGING_TAG_PREFIX = "messaging";

    TaggingHelper() {
    }

    static SpanLayer toLayer(KeyValues keyValues) {
        for (KeyValue keyValue : keyValues) {
            if (keyValue.getKey().toLowerCase(Locale.ROOT).startsWith(DB_TAG_PREFIX)) {
                return SpanLayer.DB;
            }
            if (keyValue.getKey().toLowerCase(Locale.ROOT).startsWith(HTTP_TAG_PREFIX)) {
                return SpanLayer.HTTP;
            }
            if (keyValue.getKey().toLowerCase(Locale.ROOT).startsWith(RPC_TAG_PREFIX)) {
                return SpanLayer.RPC_FRAMEWORK;
            }
            if (!keyValue.getKey().toLowerCase(Locale.ROOT).startsWith(MESSAGING_TAG_PREFIX)) continue;
            return SpanLayer.MQ;
        }
        return null;
    }
}

