/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdk.forkjoinpool;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.InstanceMethodsAroundInterceptorV2;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.MethodInvocationContext;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class ForkJoinWorkerQueueMethodInterceptor
implements InstanceMethodsAroundInterceptorV2 {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInvocationContext context) throws Throwable {
        Object storedField;
        AbstractSpan span = ContextManager.createLocalSpan((String)this.generateOperationName(objInst, method));
        span.setComponent((Component)ComponentsDefine.JDK_THREADING);
        context.setContext((Object)span);
        EnhancedInstance forkJoinTask = (EnhancedInstance)allArguments[0];
        if (forkJoinTask != null && (storedField = forkJoinTask.getSkyWalkingDynamicField()) != null) {
            ContextSnapshot contextSnapshot = (ContextSnapshot)storedField;
            ContextManager.continued((ContextSnapshot)contextSnapshot);
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret, MethodInvocationContext context) throws Throwable {
        AbstractSpan span = (AbstractSpan)context.getContext();
        if (span != null) {
            ContextManager.stopSpan((AbstractSpan)span);
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t, MethodInvocationContext context) {
        AbstractSpan span = (AbstractSpan)context.getContext();
        if (span != null) {
            span.log(t);
        }
    }

    private String generateOperationName(EnhancedInstance objInst, Method method) {
        return "ForkJoinPool/" + objInst.getClass().getName() + "/" + method.getName();
    }
}

