/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.lettuce.v5;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.tag.AbstractTag;
import org.apache.skywalking.apm.agent.core.context.tag.StringTag;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;

public class RedisCommandCancelMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final String CANCEL_SIGNAL_TAG = "signalType";
    private static final String COMMAND_CANCEL_VALUE = "cancel";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) {
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) {
        if (objInst.getSkyWalkingDynamicField() != null) {
            AbstractSpan span = (AbstractSpan)objInst.getSkyWalkingDynamicField();
            span.errorOccurred();
            span.tag((AbstractTag)new StringTag(CANCEL_SIGNAL_TAG), COMMAND_CANCEL_VALUE);
            span.asyncFinish();
            objInst.setSkyWalkingDynamicField(null);
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (objInst.getSkyWalkingDynamicField() != null) {
            AbstractSpan span = (AbstractSpan)objInst.getSkyWalkingDynamicField();
            span.log(t);
        }
    }
}

