/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.dic;

import java.io.IOException;
import java.security.AccessController;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.SpecialPermission;
import org.wltea.analyzer.dic.Dictionary;
import org.wltea.analyzer.help.ESPluginLoggerFactory;

public class Monitor
implements Runnable {
    private static final Logger logger = ESPluginLoggerFactory.getLogger(Monitor.class.getName());
    private static CloseableHttpClient httpclient = HttpClients.createDefault();
    private String last_modified;
    private String eTags;
    private String location;

    public Monitor(String location) {
        this.location = location;
        this.last_modified = null;
        this.eTags = null;
    }

    @Override
    public void run() {
        SpecialPermission.check();
        AccessController.doPrivileged(() -> {
            this.runUnprivileged();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUnprivileged() {
        RequestConfig rc = RequestConfig.custom().setConnectionRequestTimeout(10000).setConnectTimeout(10000).setSocketTimeout(15000).build();
        HttpHead head = new HttpHead(this.location);
        head.setConfig(rc);
        if (this.last_modified != null) {
            head.setHeader("If-Modified-Since", this.last_modified);
        }
        if (this.eTags != null) {
            head.setHeader("If-None-Match", this.eTags);
        }
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)head);
            if (response.getStatusLine().getStatusCode() == 200) {
                if (response.getLastHeader("Last-Modified") != null && !response.getLastHeader("Last-Modified").getValue().equalsIgnoreCase(this.last_modified) || response.getLastHeader("ETag") != null && !response.getLastHeader("ETag").getValue().equalsIgnoreCase(this.eTags)) {
                    Dictionary.getSingleton().reLoadMainDict();
                    this.last_modified = response.getLastHeader("Last-Modified") == null ? null : response.getLastHeader("Last-Modified").getValue();
                    this.eTags = response.getLastHeader("ETag") == null ? null : response.getLastHeader("ETag").getValue();
                }
            } else if (response.getStatusLine().getStatusCode() == 304) {
            } else {
                logger.info("remote_ext_dict {} return bad code {}", (Object)this.location, (Object)response.getStatusLine().getStatusCode());
            }
        }
        catch (Exception e) {
            logger.error("remote_ext_dict {} error!", (Object)e, (Object)this.location);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

